// -*- C++ -*-
TAO_BEGIN_VERSIONED_NAMESPACE_DECL

ACE_INLINE CORBA::Boolean
TAO_EC_ProxyPushConsumer::is_connected_i () const
{
  return this->connected_;
}

ACE_INLINE CORBA::Boolean
TAO_EC_ProxyPushConsumer::is_connected () const
{
  ACE_GUARD_RETURN (ACE_Lock, ace_mon, *this->lock_, false);

  return this->is_connected_i ();
}

ACE_INLINE RtecEventComm::PushSupplier_ptr
TAO_EC_ProxyPushConsumer::supplier () const
{
  ACE_GUARD_RETURN (ACE_Lock, ace_mon, *this->lock_, 0);
  return RtecEventComm::PushSupplier::_duplicate (this->supplier_.in ());
}

ACE_INLINE void
TAO_EC_ProxyPushConsumer::supplier_i (RtecEventComm::PushSupplier_ptr supplier)
{
  this->supplier_ = supplier;
}

ACE_INLINE void
TAO_EC_ProxyPushConsumer::supplier (RtecEventComm::PushSupplier_ptr supplier)
{
  ACE_GUARD (ACE_Lock, ace_mon, *this->lock_);

  this->supplier_i (supplier);
}

ACE_INLINE const RtecEventChannelAdmin::SupplierQOS&
TAO_EC_ProxyPushConsumer::publications () const
{
  // @@ TODO There should some way to signal errors here.
  ACE_GUARD_RETURN (ACE_Lock, ace_mon, *this->lock_, this->qos_);

  return this->qos_;
}

ACE_INLINE const RtecEventChannelAdmin::SupplierQOS&
TAO_EC_ProxyPushConsumer::publications_i () const
{
  return this->qos_;
}

ACE_INLINE TAO_EC_Supplier_Filter *
TAO_EC_ProxyPushConsumer::filter_i () const
{
  return this->filter_;
}

// ****************************************************************

ACE_INLINE bool
TAO_EC_ProxyPushConsumer_Guard::locked () const
{
  return this->locked_;
}

TAO_END_VERSIONED_NAMESPACE_DECL
