// Copyright (c) 2020, QuantStack and XVega Contributors
//
// Distributed under the terms of the BSD 3-Clause License.
//
// The full license is in the file LICENSE, distributed with this software.

#ifndef XVEGA_ENCODING_FACET_HPP
#define XVEGA_ENCODING_FACET_HPP

#include <optional>

#include <xproperty/xobserved.hpp>

#include <nlohmann/json.hpp>

#include "../../encoding-channel-options/aggregate.hpp"
#include "../../encoding-channel-options/bin.hpp"
#include "../../encoding-channel-options/field.hpp"
#include "../../encoding-channel-options/header.hpp"
#include "../../encoding-channel-options/sort.hpp"
#include "../../encoding-channel-options/timeunit.hpp"
#include "../../../../utils/custom_datatypes.hpp"

namespace nl = nlohmann;

namespace xv
{
    struct Facet : public xp::xobserved<Facet>
    {
        XPROPERTY(std::optional<agg_type>, Facet, aggregate);
        XPROPERTY(std::optional<std::string>, Facet, align);
        XPROPERTY(std::optional<bin_type>, Facet, bin);
        XPROPERTY(std::optional<std::string>, Facet, bounds);
        XPROPERTY(std::optional<bool>, Facet, center);
        XPROPERTY(std::optional<double>, Facet, columns);
        XPROPERTY(std::optional<field_type>, Facet, field);
        XPROPERTY(std::optional<Header>, Facet, header);
        XPROPERTY(std::optional<sort_type>, Facet, sort);
        XPROPERTY(std::optional<double>, Facet, spacing);
        XPROPERTY(std::optional<time_unit_type>, Facet, timeUnit);
        XPROPERTY(std::optional<string_vec_none_type>, Facet, title);
        XPROPERTY(std::optional<std::string>, Facet, type);
    };

    XVEGA_API void to_json(nl::json& j, const Facet& data);
}

#endif
