/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.z3;

import com.microsoft.z3.BitVecExpr;
import com.microsoft.z3.Context;
import com.microsoft.z3.FPExpr;
import com.microsoft.z3.Native;
import com.microsoft.z3.Z3Exception;

public class FPNum
extends FPExpr {
    public boolean getSign() {
        Native.IntPtr intPtr = new Native.IntPtr();
        if (!Native.fpaGetNumeralSign(this.getContext().nCtx(), this.getNativeObject(), intPtr)) {
            throw new Z3Exception("Sign is not a Boolean value");
        }
        return intPtr.value != 0;
    }

    public BitVecExpr getSignBV() {
        return new BitVecExpr(this.getContext(), Native.fpaGetNumeralSignBv(this.getContext().nCtx(), this.getNativeObject()));
    }

    public String getSignificand() {
        return Native.fpaGetNumeralSignificandString(this.getContext().nCtx(), this.getNativeObject());
    }

    public long getSignificandUInt64() {
        Native.LongPtr longPtr = new Native.LongPtr();
        if (!Native.fpaGetNumeralSignificandUint64(this.getContext().nCtx(), this.getNativeObject(), longPtr)) {
            throw new Z3Exception("Significand is not a 64 bit unsigned integer");
        }
        return longPtr.value;
    }

    public BitVecExpr getSignificandBV() {
        return new BitVecExpr(this.getContext(), Native.fpaGetNumeralSignificandBv(this.getContext().nCtx(), this.getNativeObject()));
    }

    public String getExponent(boolean bl) {
        return Native.fpaGetNumeralExponentString(this.getContext().nCtx(), this.getNativeObject(), bl);
    }

    public long getExponentInt64(boolean bl) {
        Native.LongPtr longPtr = new Native.LongPtr();
        if (!Native.fpaGetNumeralExponentInt64(this.getContext().nCtx(), this.getNativeObject(), longPtr, bl)) {
            throw new Z3Exception("Exponent is not a 64 bit integer");
        }
        return longPtr.value;
    }

    public BitVecExpr getExponentBV(boolean bl) {
        return new BitVecExpr(this.getContext(), Native.fpaGetNumeralExponentBv(this.getContext().nCtx(), this.getNativeObject(), bl));
    }

    public boolean isNaN() {
        return Native.fpaIsNumeralNan(this.getContext().nCtx(), this.getNativeObject());
    }

    public boolean isInf() {
        return Native.fpaIsNumeralInf(this.getContext().nCtx(), this.getNativeObject());
    }

    public boolean isZero() {
        return Native.fpaIsNumeralZero(this.getContext().nCtx(), this.getNativeObject());
    }

    public boolean isNormal() {
        return Native.fpaIsNumeralNormal(this.getContext().nCtx(), this.getNativeObject());
    }

    public boolean isSubnormal() {
        return Native.fpaIsNumeralSubnormal(this.getContext().nCtx(), this.getNativeObject());
    }

    public boolean isPositive() {
        return Native.fpaIsNumeralPositive(this.getContext().nCtx(), this.getNativeObject());
    }

    public boolean isNegative() {
        return Native.fpaIsNumeralNegative(this.getContext().nCtx(), this.getNativeObject());
    }

    public FPNum(Context context, long l) {
        super(context, l);
    }

    @Override
    public String toString() {
        return Native.getNumeralString(this.getContext().nCtx(), this.getNativeObject());
    }
}

